local colordots={}
function colordots.load()
gridsize=9
warpmin=50
warpmax=250
speed=1.12
time=0
vortexstrength=1
randomseed=1.25
extrapadding=50
hueshiftspeed=0.05
end
function hsvtorgb(h,s,v)
local r,g,b
local i=math.floor(h*6)
local f=h*6-i
local p=v*(1-s)
local q=v*(1-f*s)
local t=v*(1-(1-f)*s)
i=i%6
if i==0 then r,g,b=v,t,p
elseif i==1 then r,g,b=q,v,p
elseif i==2 then r,g,b=p,v,t
elseif i==3 then r,g,b=p,q,v
elseif i==4 then r,g,b=t,p,v
elseif i==5 then r,g,b=v,p,q
end
return r,g,b
end
function colordots.update(dt)
time=time+dt*speed
local randomfactor=math.sin(time*0.2+randomseed)*0.5+0.5
warpamount=warpmin+(warpmax-warpmin)*randomfactor
vortexstrength=1+math.sin(time*0.1)*0.2
end
function colordots.draw()
local width,height=love.graphics.getDimensions()
local fadestart=90.00
local fadeend=99.99
local fadefactor=1
if time>=fadestart then
fadefactor=math.max(0,(fadeend-time)/(fadeend-fadestart))
end
local bgr=(68/255)*fadefactor
local bgg=(21/255)*fadefactor
local bgb=(64/255)*fadefactor
love.graphics.setBackgroundColor(bgr,bgg,bgb)
for x=-extrapadding,width+extrapadding,gridsize do
for y=-extrapadding,height+extrapadding,gridsize do
local wavex=math.sin(y*0.02+time*vortexstrength)*warpamount*0.5
local wavey=math.cos(x*0.02+time*vortexstrength)*warpamount*0.5
local hue=(time*hueshiftspeed+(x+y)*0.0005)%1
local r,g,b=hsvtorgb(hue,1,1)
love.graphics.setColor(r,g,b,0.40*fadefactor)
love.graphics.circle("fill",x+wavex,y+wavey,3)
end end end
return colordots
